
class Utilities {
  
  removeNamespace(id) {
    return id.split(":")[1];
  }
  
  isPlayer(entity) {
    return entity.id == "minecraft:player";
  }

  isThrowPotion(entity) {
    return entity.id == "minecraft:splash_potion";
  }

  includes(array, item) {
    return array.includes(item);
  }
  
  playSound(sound, player) {
    try {
      player.runCommand(`playsound ${sound} @a`);
    } catch {}
  }
  
  damageMainhand(player, damage) {
    const container = player.getComponent("inventory").container;
    const mainhand = container.getItem(player.selectedSlot);
    
    if (!mainhand.getComponent("durability")) return;
    mainhand.getComponent("durability").damage += damage;
    
    container.setItem(player.selectedSlot, mainhand);
  }
}

export const utilities = new Utilities();
